<?php

# Hummingbird, v0.61, released 2009-12-13
# Copyright (c) 2009 by Kagan D. MacTane.
# Released under a Creative Commons license. See:
# http://kai.mactane.org/software/hummingbird/
# and
# http://creativecommons.org/licenses/by-sa/3.0/us/
#
# Regex for finding hashtags based on one at
# http://twitter.pbworks.com/Auto-Link-URLs,-Hashtags-and-@Replies

# Configuration variables...
# ------------------------------------------------------------------------
# Set your Twitter username here
$twitter_username = 'YOU MUST CHANGE THIS VALUE TO MAKE HUMMINGBIRD WORK';

# What text do you want at the top of your tweets listing?
$hb_title_text = 'My Latest Tweets:';

# What text do you want in the link to your Twitter page?
$hb_follow_link_text = 'follow me on Twitter';

# How many of your tweets should be displayed?
$num_to_display = 5;

# If you use software that auto-tweets when you post a new blog entry, 
# enter the text it places at the beginning of the tweets, and those 
# tweets will automatically be stripped from Hummingbird's output. Leave 
# this blank to disable this feature.
$strip_blogtweet_text = 'New blog post:';

# Do you want to strip out @replies? (Only affects tweets with @reply at 
# the beginning; tweets with @username references elsewhere will always 
# be displayed.)
$strip_at_replies = true;

# How many seconds should Hummingbird keep Twitter feed data cached for
# before updating or refreshing? It is very unwise to set this below 60!
$cache_time = 300;

# You shouldn't need to change anything after this line.
# ------------------------------------------------------------------------


$cache_file = preg_replace("/\.php$/", '.xml', __FILE__);


if ($twitter_username == 'YOU MUST CHANGE THIS VALUE TO MAKE HUMMINGBIRD WORK') {
	print "You need to change the <code>\$twitter_username</code> variable at the beginning of the hummingbird.php file. It's the one labeled \"$twitter_username\".";
	return;
}

# If Hummingbird is called by WordPress, or other blog or framework 
# software, it will probably be way down the execution stack, so the
# global keyword won't work - variables defined at the top level of
# this file are still miles from being in the global scope. Just make
# them constants so freshen_cache_file() can read them when it needs them.
define("HUMMINGBIRD_NAME", $twitter_username);
define('HUMMINGBIRD_TIME', $cache_time);
define('HUMMINGBIRD_NUM', $num_to_display);

if (isset($argc) && $argc) {
	ini_set("error_reporting", E_ALL & ~E_NOTICE);
	freshen_cache_file($cache_file, true);
	exit;
}

$xml = freshen_cache_file($cache_file);

print "<div id=\"hummingbird_div\">\n\t<h2 id=\"hummingbird_title\">$hb_title_text</h2>\n\n";

if (isset($err) && $err) {
	print "\t<p id=\"#hummingbird_error\">$err</p>\n";
} else {
	print "\t<ul id=\"hummingbird_list\">\n";
	$printed = 0;
	foreach ($xml->status as $tweet) {
		if ($strip_at_replies && substr(strip_tags($tweet->text), 0, 1) == '@') {
			continue;
		}
		if ($strip_blogtweet_text && substr($tweet->text, 0, strlen($strip_blogtweet_text)) == $strip_blogtweet_text) {
			continue;
		}
		$t_text = $tweet->text;
		$t_text = preg_replace("/(http:\/\/\S+)/", "<a href=\"$1\" class=\"hb_other_link\">$1</a>", $t_text);
		$t_text = preg_replace("/(www\.\S+)/", "<a href=\"http://$1\" class=\"hb_other_link\">$1</a>", $t_text);
		$t_text = preg_replace("/@(\w+)/", "@<a href=\"http://twitter.com/$1\" class=\"hb_atuser_link\">$1</a>", $t_text);
		$t_text = preg_replace("/(^|\W)\#([-\w\.+:=]+\w)(\W|$)/", "$1<a href=\"http://hashtags.org/tag/$2/\" class=\"hb_hashtag_link\">#$2</a>$3", $t_text);
		$t_date = time_ago(strtotime($tweet->created_at));
		$t_url = "http://twitter.com/$twitter_username/statuses/" . $tweet->id;
		print "\t\t<li>$t_text <a href=\"$t_url\" class=\"hb_tweet_link\">$t_date</a></li>\n";
		if (++$printed >= $num_to_display) {
			break;
		}
	}
	print "\t</ul>\n";
}

print "\t<p id=\"hummingbird_link_para\"><a href=\"http://twitter.com/$twitter_username\" id=\"hummingbird_twitter_link\">$hb_follow_link_text</a></p>\n";
print "</div>\n\n";
ob_flush();
flush();
return;

function freshen_cache_file($cache_file, $cli = false) {
	if (file_exists($cache_file)) {
		$cachefile_timestamp = filemtime($cache_file);
		$now = time();
		try {
			$xml = new SimpleXMLElement(file_get_contents($cache_file));
			if ($now - $cachefile_timestamp < HUMMINGBIRD_TIME) {
				return $xml;
			}
			if ($xml->ratelimit->remaining / $xml->ratelimit->limit < 0.05) {
				if ($now < $xml->ratelimit->reset) {
					return $xml;
				}
			}
		} catch (Exception $e) {
			if ($e->getMessage() != 'String could not be parsed as XML') {
				throw $e;
			}
		}
	}

	$cache_updater = preg_replace("/\.php$/", '-cache.php', __FILE__);

	# Get 3 times as many tweets as we're going to display, because
	# we might throw some away based on $strip_* settings.
	$c3 = HUMMINGBIRD_NUM * 3;
	$hb_name = HUMMINGBIRD_NAME;
	$hb_time = HUMMINGBIRD_TIME;
	exec("php $cache_updater $c3 $hb_name $hb_time > /dev/null 2>&1 &");
	return $xml;
}



function time_ago($time) {
	$elapsed = time() - $time;
	if ($elapsed < 55) {
		return "$elapsed seconds ago";
	} elseif ($elapsed < 55 * 60) {
		$num = floor($elapsed / 60);
		$percent = floor(100 * (($elapsed % 60) / 60));
		$unit = 'minute';
	} elseif ($elapsed < 23.5 * 60 * 60) {
		$num = floor($elapsed / 3600);
		$percent = floor(100 * (($elapsed % 3600) / 3600));
		$unit = 'hour';
	} elseif ($elapsed < 3 * 86400) {
		$num = floor($elapsed / 86400);
		$percent = floor(100 * (($elapsed % 86400) / 86400));
		$unit = 'day';
	} else {
		return date('H:i, M&\n\b\s\p;j', $time);
	}
	
	if ($percent < 5 || $percent > 95) {
		$modifier = '';
		if ($percent > 95) { $num++; }
	} elseif ($percent <= 20) {
		$modifier = 'just over';
	} elseif ($percent <= 50) {
		$modifier = 'about';
	} elseif ($percent <= 80) {
		$modifier = 'about';
		$num++;
	} else {
		$modifier = 'nearly';
		$num++;
	}
	
	$sp = (strlen($modifier)) ? ' ' : '';
	$pl = ($num == 1) ? '' : 's';
	return "$modifier$sp$num $unit$pl ago";
}




?>
